:: Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018
:: 
:: All rights reserved. All hardware and software names used are registered
:: trade names and/or registered trademarks of the respective manufacturers.
:: 
:: The user of this computer program acknowledges that the above copyright
:: notice, which constitutes the Universal Copyright Convention, will be attached
:: at the position in the function of the computer program which the author has
:: deemed to sufficiently express the reservation of copyright. It is prohibited for
:: customers, users and/or third parties to remove, modify or move this
:: copyright notice.
@echo off
chcp 1252 > NUL
set fscClientInformationToolVersion=1.5
goto Main

::Localization
:PrintText
::%1=TextID
goto LocText%1%fscLang% 2>> "%fscDebugLog%"
goto LocText%1INT 2>> "%fscDebugLog%"
echo Unknown TextID %1 1>&2
echo Unknown TextID %1 >> "%fscDebugLog%"
goto :EOF
:LocTextZipErrorINT
echo Could not zip files please zip "ClientInformationTool_%fscUID%\files" and upload it to the Service Desk 1>&2
goto :EOF
:LocTextZipErrorDEU
echo Konnte die Datei "ClientInformation (%fscDate%).zip" nicht erstellen, bitte erstellen Sie eine ZIP-Datei des Verzeichnis "ClientInformationTool_%fscUID%\files" und laden diese auf den Service Desk 1>&2
goto :EOF
:LocTextUnkErrorINT
echo Unknown error please zip "ClientInformationTool" and upload it to the Service Desk 1>&2
goto :EOF
:LocTextUnkErrorDEU
echo Unbekannter Fehler bitte erstellen Sie eine ZIP-Datei des Verzeichnis "ClientInformationTool" und laden diese auf den Service Desk 1>&2
goto :EOF
:LocTextZipOKINT
echo Created "%CD%\ClientInformation (%fscDate%).zip" please upload this file to the Service Desk 1>&2
goto :EOF
:LocTextZipOKDEU
echo Die Datei "%CD%\ClientInformation (%fscDate%).zip" wurde erstellt, bitte laden Sie diese Datei auf den Service Desk 1>&2
goto :EOF
:LocTextOSInfoDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Betriebssystem Informationen 1>&2
goto :EOF
:LocTextOSInfoINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Operating System Information 1>&2
goto :EOF
:LocTextUserInfoDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Benutzer Informationen 1>&2
goto :EOF
:LocTextUserInfoINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Current User Information 1>&2
goto :EOF
:LocTextBrowserInfoDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Browser Informationen 1>&2
goto :EOF
:LocTextBrowserInfoINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Browser Information 1>&2
goto :EOF
:LocTextOfficeInfoDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Office Suite Informationen 1>&2
goto :EOF
:LocTextOfficeInfoINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Office Suite Information 1>&2
goto :EOF
:LocTextApplicationInfoDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Anwendungs Informationen 1>&2
goto :EOF
:LocTextApplicationInfoINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Application Information 1>&2
goto :EOF
:LocTextWINEventLogsDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Windows Ereignislogs 1>&2
goto :EOF
:LocTextWINEventLogsINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Windows Eventlogs 1>&2
goto :EOF
:LocTextFSCOverviewDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Installierte Fabasoft Software 1>&2
goto :EOF
:LocTextFSCOverviewINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Fabasoft Software Overview 1>&2
goto :EOF
:LocTextFSCPluginDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Fabasoft Plugin Informationen 1>&2
goto :EOF
:LocTextFSCPluginINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Fabasoft Plugin Information 1>&2
goto :EOF
:LocTextFSCPluginLogsDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Fabasoft Plugin Logs 1>&2
goto :EOF
:LocTextFSCPluginLogsINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Fabasoft Plugin Logs 1>&2
goto :EOF
:LocTextFSCPrinterDEU
echo Sammle Informationen %fscProgress%/%fscProgressMax%: Fabasoft Printer Port Informationen 1>&2
goto :EOF
:LocTextFSCPrinterINT
echo Collecting Information %fscProgress%/%fscProgressMax%: Fabasoft Printer Port Information 1>&2
goto :EOF
:LocTextFinalizeDEU
echo Erstelle eine ZIP-Datei mit den gesammelten Informationen, bitte warten... 1>&2
goto :EOF
:LocTextFinalizeINT
echo Zipping collected information please wait... 1>&2
goto :EOF

::Script Framework Functions
:Error
::%1=ErrorID
if %1==zipError (
	call :PrintText ZipError
) else (
	call :PrintText UnkError
)
goto :EOF

:RegValue
::%1=Key
::%2=Regex
::%3=Index (for REG_MULTI_SZ)
set fscRegValue=
if "%fscPowershell%"=="true" (
	for /F "usebackq delims=" %%i in (`powershell -Command "$value = [Microsoft.Win32.Registry]::GetValue('%~1', '', $null); if($value -eq $null) { $value = [Microsoft.Win32.Registry]::GetValue([System.IO.Path]::GetDirectoryName('%~1'), [System.IO.Path]::GetFileName('%~1'), $null); } $output=''; if($value -ne $null) { $output=$value.ToString(); if($output -eq 'System.String[]') { $output=$value[%~3] } } if($output -match '%~2') { $output=$Matches[0]; } else { $output=''; } Write-Host $output;"`) do set fscRegValue=%%~i
) else ( 
	for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscRegValue.vbs" "%~1" %2 %3 2^>^> "%fscDebugLog%"') do set fscRegValue=%%~i
)
goto :EOF

:Initialize
::Initialize Temp Folder
set fscUID=%RANDOM%
set fscAppPath=ClientInformationTool_%fscUID%
set fscTempPath=ClientInformationTool_%fscUID%\files
if exist "%fscAppPath%" rmdir /S /Q "%fscAppPath%\"
mkdir "%fscAppPath%"
mkdir "%fscTempPath%"
mkdir "%fscTempPath%\logs"
::Create Log
echo Client Information Tool Version %fscClientInformationToolVersion% 1>&2
echo Client Information Tool Logfile Version %fscClientInformationToolVersion% > "%fscTempPath%\FileType.txt"
call :InitVBS
::Set Global Variables
set fscDebugLog=%fscTempPath%\debug.log
set fscProgramFilesX86=%ProgramFiles%
if %PROCESSOR_ARCHITECTURE%==AMD64 set fscProgramFilesX86=%ProgramFiles(x86)%
set fscPowershell=false
for /F "delims=" %%i in ('powershell -Command "Write-Host 'true'" 2^>^> "%fscDebugLog%"') do set fscPowershell=%%~i
if "%fscPowershell%"=="true" call :InitPowershell
call :RegValue "HKEY_CURRENT_USER\Control Panel\Desktop\MUICached\MachinePreferredUILanguages" "^^\w{2}" 0
set fscLang=
if "%fscRegValue%"=="de" ( set fscLang=DEU )
if "%fscRegValue%"=="en" ( set fscLang=INT )
if "%fscLang%"=="" (
	call :RegValue "HKEY_LOCAL_MACHINE\System\CurrentControlSet\Control\NLS\Language\InstallLanguage"
	if "%fscRegValue%"==0409 ( set fscLang=DEU )
)
if "%fscLang%"=="" ( set fscLang=INT )
set fscDate=
for /F "delims=" %%i in ('date /T ^| find "/" 2^>^> "%fscDebugLog%"') do set fscDate=%%i
if "%fscDate%"=="" (
	for /F "tokens=1,2,3 delims=. " %%i in ('date /T 2^>^> "%fscDebugLog%"') do set fscDate=%%k-%%j-%%i
) else (
	for /F "tokens=2,3,4 delims=/ " %%i in ('date /T 2^>^> "%fscDebugLog%"') do set fscDate=%%k-%%i-%%j
)
for /F "tokens=3 delims=. " %%i in ('ver') do set winVersionMajor=%%~i
if %winVersionMajor%==XP (
	set winVersionMajor=5
	set winVersionMinor=1
) else (
	for /F "tokens=4 delims=. " %%i in ('ver') do set winVersionMajor=%%~i
	for /F "tokens=5 delims=. " %%i in ('ver') do set winVersionMinor=%%~i
)
if %winVersionMajor% LSS 6 (
	call :RegValue "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\Local AppData"
	set LOCALAPPDATA=%fscRegValue%
)
goto :EOF

:Cleanup
::Zip Files
set fscZipResult=
if exist "ClientInformation (%fscDate%).zip.bak" ( del /F /Q "ClientInformation (%fscDate%).zip.bak" >> NUL )
if exist "ClientInformation (%fscDate%).zip" move "ClientInformation (%fscDate%).zip" "ClientInformation (%fscDate%).zip.bak" >> NUL
if "%fscPowershell%"=="true" (
	powershell -ExecutionPolicy RemoteSigned -File "%fscAppPath%\fscManifest.ps1" "%fscTempPath%"
	powershell -ExecutionPolicy RemoteSigned -File "%fscAppPath%\fscZip.ps1" "%fscTempPath%" "ClientInformation (%fscDate%).zip"
	if not exist "ClientInformation (%fscDate%).zip" (
		for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscZip.vbs" "%fscTempPath%" "ClientInformation (%fscDate%).zip"') do set fscZipResult=%%~i
	) else (
		set fscZipResult=OK
	)
) else (
	for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscZip.vbs" "%fscTempPath%" "ClientInformation (%fscDate%).zip"') do set fscZipResult=%%~i
)
del /F /Q "%fscAppPath%\fscApplicationInfo.vbs"
del /F /Q "%fscAppPath%\fscVersionInfo.vbs"
del /F /Q "%fscAppPath%\fscRegValue.vbs"
del /F /Q "%fscAppPath%\fscRegInfo.vbs"
del /F /Q "%fscAppPath%\fscZip.vbs"
del /F /Q "%fscAppPath%\fscApplicationInfo.ps1"
del /F /Q "%fscAppPath%\fscManifest.ps1"
del /F /Q "%fscAppPath%\fscRegInfo.ps1"
del /F /Q "%fscAppPath%\fscZip.ps1"
::Check Zip
if "%fscZipResult%"=="OK" (
	rmdir /S /Q "%fscAppPath%\"
	if exist "ClientInformation (%fscDate%).zip" (
		set fscError=zipOK
	) else (
		set fscError=zipError
	)
) else (
	set fscError=zipError
)
goto :EOF

:Finalize
set fscDebugLog=ClientInformation_%fscUID%.log
call :Cleanup 2>> "%fscDebugLog%" 1>&2
if "%fscError%"=="zipOK" (
	call :PrintText ZipOK
	del /F /Q "%fscDebugLog%"
) else (
	call :Error %fscError%
)
goto :EOF

:PrintDebugText
::%1=Text
echo %~1 >> "%fscDebugLog%"
goto :EOF

:PrintLogText
::%1=Logfilename
::%2=Text
echo PrintLogText Logfilename=%1 Text=%2 >> "%fscDebugLog%"
echo %~2 >> "%fscTempPath%\logs\%~1.log"
goto :EOF

:PrintLogRegistry
::%1=Logfilename
::%2=Hive
::%3=Key
::%4=Regex
echo PrintLogRegistry Logfilename=%1 Hive=%2 Key=%3 Regex=%4 >> "%fscDebugLog%"
if "%fscPowershell%"=="true" (
	powershell -ExecutionPolicy RemoteSigned -File "%fscAppPath%\fscRegInfo.ps1" "%~2" "%~3" "%~4" >> "%fscTempPath%\logs\%~1.log" 2>> "%fscDebugLog%"
) else (
	cscript /nologo "%fscAppPath%\fscRegInfo.vbs" "%~2" "%~3" "%~4 >> "%fscTempPath%\logs\%~1.log" 2>> "%fscDebugLog%"
)
goto :EOF

:PrintLogVersion
::%1=Logfilename
::%2=Displayname
::%3=Filepath
echo PrintLogVersion Logfilename=%1 Displayname=%2 Filepath=%3 >> "%fscDebugLog%"
if "%fscPowershell%"=="true" (
	powershell -Command "Write-Host ([String]::Format('{0}: {1} ({2}) [{3}]', '%~2', [System.Diagnostics.FileVersionInfo]::GetVersionInfo('%~3').FileVersion,(New-Object System.IO.FileInfo('%~3')).Length, [BitConverter]::ToString((new-object Security.Cryptography.SHA256Managed).ComputeHash([System.IO.File]::ReadAllBytes('%~3'))).Replace('-','')))" >> "%fscTempPath%\logs\%~1.log" 2>> "%fscDebugLog%"
) else (
	for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscVersionInfo.vbs" "%~3" 2^>^> "%fscDebugLog%"') do set fscVersionInfo=%%~i
	echo %~2: %fscVersionInfo% >> "%fscTempPath%\logs\%~1.log"
)
goto :EOF

:PrintLog
::%1=Logfilename
::%2=Command
::%3=Parameterlist
::%4-%9=Parameters
echo PrintLog Logfilename=%1 Command=%2 Parameterlist=%3 Parameter0=%4 Parameter1=%5 Parameter2=%6 Parameter3=%7 Parameter4=%8 Parameter5=%9 >> "%fscDebugLog%"
%2 %~3 %4 %5 %6 %7 %8 %9 >> "%fscTempPath%\logs\%~1.log" 2>> "%fscDebugLog%"
goto :EOF

::Logging Functions
:OSInfo
call :PrintDebugText "OSInfo"
call :PrintLogText osinfo "####OSInfo####"
call :PrintLogText osinfo "----Overview----"
call :PrintLog osinfo systeminfo
call :PrintLogText osinfo "----Network----"
call :PrintLog osinfo ipconfig /all
call :PrintLogText osinfo "----Environment Variables----"
call :PrintLog osinfo set
goto :EOF

:UserInfo
call :PrintDebugText "UserInfo"
call :PrintLogText userinfo "####UserInfo####"
call :PrintLog userinfo net "user /domain %username%"
goto :EOF

:BrowserInfo
call :PrintDebugText "BrowserInfo"
call :PrintLogText browserinfo "####BrowserInfo####"
call :PrintLogText browserinfo "----Internet Explorer----"
call :PrintLogVersion browserinfo iexplore.exe "%ProgramFiles%\Internet Explorer\iexplore.exe"
call :PrintLogText browserinfo "====Zone Settings===="
call :PrintLogRegistry browserinfo HKEY_CURRENT_USER "Software\Microsoft\Windows\CurrentVersion\Internet Settings\ZoneMap"
call :PrintLogRegistry browserinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Internet Settings\ZoneMap"
call :PrintLogText browserinfo "See ""http://msdn.microsoft.com/en-us/library/ms537178(v=vs.85).aspx""..."
call :PrintLogRegistry browserinfo HKEY_CURRENT_USER "Software\Microsoft\Windows\CurrentVersion\Internet Settings\Zones"
call :PrintLogRegistry browserinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Internet Settings\Zones"
call :PrintLogText browserinfo "====Browser Helper Objects===="
call :PrintLogRegistry browserinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\explorer\Browser Helper Objects"
call :PrintLogText browserinfo "====Toolbars===="
call :PrintLogRegistry browserinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Internet Explorer\Toolbar"
call :PrintLogText browserinfo "====Extensions===="
call :PrintLogRegistry browserinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Internet Explorer\Extensions"
if exist "%fscProgramFilesX86%\Mozilla Firefox\firefox.exe" ( 
	call :PrintLogText browserinfo "----Mozilla Firefox----"
	call :PrintLogVersion browserinfo firefox.exe "%fscProgramFilesX86%\Mozilla Firefox\firefox.exe"
) else if exist "%LOCALAPPDATA%\Mozilla Firefox\firefox.exe" (
	call :PrintLogText browserinfo "----Mozilla Firefox----"
	call :PrintLogVersion browserinfo firefox.exe "%LOCALAPPDATA%\Mozilla Firefox\firefox.exe"
)
if exist "%fscProgramFilesX86%\Google\Chrome\Application\chrome.exe" ( 
	call :PrintLogText browserinfo "----Google Chrome----"
	call :PrintLogVersion browserinfo chrome.exe "%fscProgramFilesX86%\Google\Chrome\Application\chrome.exe"
) else if exist "%LOCALAPPDATA%\Google\Chrome\Application\chrome.exe" (
	call :PrintLogText browserinfo "----Google Chrome----"
	call :PrintLogVersion browserinfo chrome.exe "%LOCALAPPDATA%\Google\Chrome\Application\chrome.exe"
)
goto :EOF

:OfficeInfo
call :PrintDebugText "OfficeInfo"
call :PrintLogText officeinfo "####OfficeInfo####"
call :PrintLogText officeinfo "----Microsoft Office----"
call :RegValue "HKEY_CLASSES_ROOT\Outlook.Application\CurVer\" "\d{2}$"
set msOfficeOutlookVersion=%fscRegValue%
call :RegValue "HKEY_CLASSES_ROOT\Word.Application\CurVer\" "\d{2}$"
set msOfficeWordVersion=%fscRegValue%
call :RegValue "HKEY_CLASSES_ROOT\Excel.Application\CurVer\" "\d{2}$"
set msOfficeExcelVersion=%fscRegValue%
call :RegValue "HKEY_CLASSES_ROOT\PowerPoint.Application\CurVer\" "\d{2}$"
set msOfficePowerPointVersion=%fscRegValue%
if exist "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeOutlookVersion%\outlook.exe" ( 
	call :PrintLogVersion officeinfo "outlook.exe" "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeOutlookVersion%\outlook.exe"
)
if exist "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeWordVersion%\winword.exe" ( 
	call :PrintLogVersion officeinfo "winword.exe" "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeWordVersion%\winword.exe"
)
if exist "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeExcelVersion%\excel.exe" ( 
	call :PrintLogVersion officeinfo "excel.exe" "%fscProgramFilesX86%\Microsoft Office\Office%msOfficeExcelVersion%\excel.exe"
)
if exist "%fscProgramFilesX86%\Microsoft Office\Office%msOfficePowerPointVersion%\powerpnt.exe" ( 
	call :PrintLogVersion officeinfo "powerpnt.exe" "%fscProgramFilesX86%\Microsoft Office\Office%msOfficePowerPointVersion%\powerpnt.exe"
)
if %PROCESSOR_ARCHITECTURE%==AMD64 (
	if exist "%ProgramFiles%\Microsoft Office\Office%msOfficeOutlookVersion%\outlook.exe" ( 
		call :PrintLogVersion officeinfo "outlook.exe (x64)" "%ProgramFiles%\Microsoft Office\Office%msOfficeOutlookVersion%\outlook.exe"
	)
	if exist "%ProgramFiles%\Microsoft Office\Office%msOfficeWordVersion%\winword.exe" ( 
		call :PrintLogVersion officeinfo "winword.exe (x64)" "%ProgramFiles%\Microsoft Office\Office%msOfficeWordVersion%\winword.exe"
	)
	if exist "%ProgramFiles%\Microsoft Office\Office%msOfficeExcelVersion%\excel.exe" ( 
		call :PrintLogVersion officeinfo "excel.exe (x64)" "%ProgramFiles%\Microsoft Office\Office%msOfficeExcelVersion%\excel.exe"
	)
	if exist "%ProgramFiles%\Microsoft Office\Office%msOfficePowerPointVersion%\powerpnt.exe" ( 
		call :PrintLogVersion officeinfo "powerpnt.exe (x64)" "%ProgramFiles%\Microsoft Office\Office%msOfficePowerPointVersion%\powerpnt.exe"
	)
)
call :PrintLogText officeinfo "====Outlook Addins===="
call :PrintLogRegistry officeinfo HKEY_CURRENT_USER "Software\Microsoft\Office\Outlook\Addins"
call :PrintLogRegistry officeinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Office\Outlook\Addins"
call :PrintLogText officeinfo "====Word Addins===="
call :PrintLogRegistry officeinfo HKEY_CURRENT_USER "Software\Microsoft\Office\Word\Addins"
call :PrintLogRegistry officeinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Office\Word\Addins"
call :PrintLogText officeinfo "====Excel Addins===="
call :PrintLogRegistry officeinfo HKEY_CURRENT_USER "Software\Microsoft\Office\Excel\Addins"
call :PrintLogRegistry officeinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Office\Excel\Addins"
call :PrintLogText officeinfo "====Powerpoint Addins===="
call :PrintLogRegistry officeinfo HKEY_CURRENT_USER "Software\Microsoft\Office\PowerPoint\Addins"
call :PrintLogRegistry officeinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Office\PowerPoint\Addins"
goto :EOF

:PrintApplicationInfo
::%1=Extension
echo PrintApplicationInfo Extension=%1 >> "%fscDebugLog%"
set fscApplicationInfo=
if "%fscPowershell%"=="true" (
	powershell -ExecutionPolicy RemoteSigned -File "%fscAppPath%\fscApplicationInfo.ps1" "%~1" >> "%fscTempPath%\logs\applicationinfo.log" 2>> "%fscDebugLog%"
) else (
	for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscApplicationInfo.vbs" "%~1" 2^>^> "%fscDebugLog%"') do set fscApplicationInfo=%%~i
	if not exist "%fscApplicationInfo%" goto :EOF
	for /F "delims=" %%i in ('cscript //nologo "%fscAppPath%\fscVersionInfo.vbs" "%fscApplicationInfo%" 2^>^> "%fscDebugLog%"') do set fscVersionInfo=%%~i
	echo %~1: "%fscApplicationInfo%" %fscVersionInfo% >> "%fscTempPath%\logs\applicationinfo.log"
)
goto :EOF

:ApplicationInfo
call :PrintDebugText "ApplicationInfo"
call :PrintLogText applicationinfo "####ApplicationInfo####"
call :PrintLogText applicationinfo "----Filetype Associations----"
call :PrintApplicationInfo .pdf
call :PrintApplicationInfo .zip
call :PrintApplicationInfo .tif
call :PrintApplicationInfo .jpg
call :PrintApplicationInfo .png
call :PrintApplicationInfo .gif
call :PrintApplicationInfo .txt
call :PrintApplicationInfo .dwg
call :PrintApplicationInfo .doc
call :PrintApplicationInfo .docx
call :PrintApplicationInfo .docm
call :PrintApplicationInfo .odt
call :PrintApplicationInfo .xls
call :PrintApplicationInfo .xlsx
call :PrintApplicationInfo .xlsm
call :PrintApplicationInfo .ods
call :PrintApplicationInfo .ppt
call :PrintApplicationInfo .pptx
call :PrintApplicationInfo .msg
call :PrintApplicationInfo .eml
call :PrintApplicationInfo .htm
call :PrintApplicationInfo .html
call :PrintApplicationInfo http
call :PrintApplicationInfo https
call :PrintLogText applicationinfo "----Installed Applications----"
call :PrintLogRegistry applicationinfo HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall" "^^Display(Name|Version)"
if %PROCESSOR_ARCHITECTURE%==AMD64 (
	call :PrintLogText applicationinfo "----Installed Applications (32Bit)----"
	call :PrintLogRegistry applicationinfo HKEY_LOCAL_MACHINE "Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall" "^^Display(Name|Version)"
)
goto :EOF

:WINEventLogs
call :PrintDebugText "WINEventLogs"
mkdir "%fscTempPath%\eventlogs"
if %winVersionMajor%==5 (
	wmic nteventlog where "Logfilename = 'Application'" Call BackupEventlog "%fscTempPath%\eventlogs\Application.evt" >> "%fscDebugLog%" 2>&1
	wmic nteventlog where "Logfilename = 'System'" Call BackupEventlog "%fscTempPath%\eventlogs\System.evt" >> "%fscDebugLog%" 2>&1
	if not exist "%fscTempPath%\eventlogs\Application.evt" ( 
		if not exist "%fscTempPath%\eventlogs\System.evt" (
			rmdir /Q "%fscTempPath%\eventlogs" >> "%fscDebugLog%" 2>&1
		)
	)
) else if %winVersionMajor% GEQ 6 (
	wevtutil epl Application "%fscTempPath%\eventlogs\Application.evtx" >> "%fscDebugLog%" 2>&1
	wevtutil epl System "%fscTempPath%\eventlogs\System.evtx" >> "%fscDebugLog%" 2>&1
	if not exist "%fscTempPath%\eventlogs\Application.evtx" ( 
		if not exist "%fscTempPath%\eventlogs\System.evtx" (
			rmdir /Q "%fscTempPath%\eventlogs" >> "%fscDebugLog%" 2>&1
		)
	)
)
goto :EOF

:FSCOverview
call :PrintDebugText "FSCOverview"
call :PrintLogText fscoverview "####FSCOverview####"
call :PrintLogText fscoverview "----Registry----"
call :PrintLogRegistry fscoverview HKEY_CURRENT_USER "Software\Fabasoft"
call :PrintLogRegistry fscoverview HKEY_LOCAL_MACHINE "Software\Fabasoft"
call :PrintLogText fscoverview "----Directories----"
call :PrintLog fscoverview dir /B /S "%ProgramFiles%\Fabasoft"
if %PROCESSOR_ARCHITECTURE%==AMD64 (
	call :PrintLog fscoverview dir /B /S "%ProgramFiles(x86)%\Fabasoft"
)
call :PrintLogText fscoverview "----Temp----"
call :PrintLog fscoverview dir "/B /S ""%TEMP%\fsc.client"""
call :PrintLog fscoverview dir "/B /S ""%TEMP%\fabasoft.plugin"""
call :PrintLog fscoverview dir "/B /S ""%TEMP%\Fabasoft"""
goto :EOF

:FSCPlugin
call :PrintDebugText "FSCPlugin"
call :PrintLogText fscplugins "####FSCPlugin####"
call :PrintLogText fscplugins "----Registry----"
call :PrintLogRegistry fscplugins HKEY_CURRENT_USER "Software\Fabasoft\WebClient\ConfigValues"
call :PrintLogRegistry fscplugins HKEY_CURRENT_USER "Software\VB and VBA Program Settings"
call :PrintLogText fscplugins "----Libaries----"
if exist "%fscProgramFilesX86%\Fabasoft\Components\WebClient\" (
	call :PrintLogText fscplugins "%fscProgramFilesX86%\Fabasoft\Components\WebClient:"
	for /F "delims=" %%i in ('dir /B /S "%fscProgramFilesX86%\Fabasoft\Components\WebClient\*.dll" 2^>^> "%fscDebugLog%"') do (
		call :PrintLogVersion fscplugins %%~ni.dll "%%~i"
	)
)
for /F "delims=" %%d in ('dir /A:D /O /B "%fscProgramFilesX86%\Fabasoft\Folio*" 2^>^> "%fscDebugLog%"') do (
	for /F "delims=" %%e in ('dir /A:D /O /B /S "%fscProgramFilesX86%\Fabasoft\%%~d\*" 2^>^> "%fscDebugLog%"') do (
		if exist "%%~e\*.dll" (
			call :PrintLogText fscplugins "%%~e:"
		) else if exist "%%~e\*.exe" (
			call :PrintLogText fscplugins "%%~e:"
		)
		for /F "delims=" %%i in ('dir /O /B "%%~e\*.dll" "%%~e\*.exe" 2^>^> "%fscDebugLog%"') do (
			call :PrintLogVersion fscplugins %%~ni%%~xi "%%~e\%%~i"
		)
	)
)
call :PrintLogText fscplugins "----Cloud----"
if exist "%LOCALAPPDATA%\Fabasoft\x86\" (
	call :PrintLogText fscplugins "%LOCALAPPDATA%\Fabasoft\x86:"
	for /F "delims=" %%i in ('dir /B /S "%LOCALAPPDATA%\Fabasoft\x86\*.dll" 2^>^> "%fscDebugLog%"') do (
		if /I "%%~xi"==".dll" (
			call :PrintLogVersion fscplugins %%~ni.dll "%%~i"
		)
	)
)
if exist "%LOCALAPPDATA%\Fabasoft\x64\" (
	call :PrintLogText fscplugins "%LOCALAPPDATA%\Fabasoft\x64:"
	for /F "delims=" %%i in ('dir /B /S "%LOCALAPPDATA%\Fabasoft\x64\*.dll" 2^>^> "%fscDebugLog%"') do (
		if /I "%%~xi"==".dll" (
			call :PrintLogVersion fscplugins %%~ni.dll "%%~i"
		)
	)
)
goto :EOF

:FSCPluginLogs
call :PrintDebugText "FSCPluginLogs"
dir /B /AD "%TEMP%\fsc.client\log\*" 2>>"%fscDebugLog%" | >nul findstr "^" 2>nul && (
	mkdir "%fscTempPath%\pluginlogs\old" >> "%fscDebugLog%" 2>&1
	xcopy /S "%TEMP%\fsc.client\log" "%fscTempPath%\pluginlogs\old" >> "%fscDebugLog%" 2>&1
)
dir /B /AD "%TEMP%\Fabasoft\Logs\*" 2>>"%fscDebugLog%" | >nul findstr "^" 2>nul && (
	mkdir "%fscTempPath%\pluginlogs\new" >> "%fscDebugLog%" 2>&1
	xcopy /S "%TEMP%\Fabasoft\Logs" "%fscTempPath%\pluginlogs\new" >> "%fscDebugLog%" 2>&1
)
goto :EOF

:FSCPrinter
call :PrintDebugText "FSCPrinter"
if exist "%SystemRoot%\System32\fscprintimportmonitor.dll" (
	call :PrintLogText fscprinter "####FSCPrinter####"
	call :PrintLogText fscprinter "----Registry----"
	call :PrintLogRegistry fscprinter HKEY_CURRENT_USER "Software\Fabasoft\WebClient\ConfigValues"
	call :PrintLogText fscprinter "----Libaries----"
	call :PrintLogVersion fscprinter fscprintimportconfig.dll "%SystemRoot%\System32\fscprintimportconfig.dll"
	call :PrintLogVersion fscprinter fscprintimportmonitor.dll "%SystemRoot%\System32\fscprintimportmonitor.dll"
)
goto :EOF

::Main Function
:Main
call :Initialize
set fscProgressMax=10
set fscProgress=1
call :PrintText OSInfo
call :OSInfo
set fscProgress=2
call :PrintText UserInfo
call :UserInfo
set fscProgress=3
call :PrintText BrowserInfo
call :BrowserInfo
set fscProgress=4
call :PrintText OfficeInfo
call :OfficeInfo
set fscProgress=5
call :PrintText ApplicationInfo
call :ApplicationInfo
set fscProgress=6
call :PrintText WINEventLogs
call :WINEventLogs
set fscProgress=7
call :PrintText FSCOverview
call :FSCOverview
set fscProgress=8
call :PrintText FSCPlugin
call :FSCPlugin
set fscProgress=9
call :PrintText FSCPluginLogs
call :FSCPluginLogs
set fscProgress=10
call :PrintText FSCPrinter
call :FSCPrinter
call :PrintText Finalize
call :Finalize
chcp 850 > NUL
pause 1>&2
goto :EOF

:InitVBS 
::Create fscApplicationInfo.vbs 
echo ' Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscApplicationInfo.vbs"
echo '  >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscApplicationInfo.vbs"
echo '  >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' at the position in the function of the computer program which the author has >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscApplicationInfo.vbs"
echo ' copyright notice. >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Set args = WScript.Arguments >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Set shell = CreateObject("Wscript.Shell") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Dim application >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Dim apptype >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Dim applist >> "%fscAppPath%\fscApplicationInfo.vbs"
echo On Error Resume Next >> "%fscAppPath%\fscApplicationInfo.vbs"
echo applist = shell.RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" ^& args(0) ^& "\OpenWithList\MRUList") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo apptype = shell.RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" ^& args(0) ^& "\OpenWithList\" ^& Mid(applist,1,1)) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = shell.RegRead("HKEY_CLASSES_ROOT\Applications\" ^& apptype ^& "\shell\open\command\") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo If Err.Number ^<^> 0 Then >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = shell.RegRead("HKEY_CLASSES_ROOT\" ^& args(0) ^& "\shell\open\command\") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo If Err.Number ^<^> 0 Then >> "%fscAppPath%\fscApplicationInfo.vbs"
echo apptype = shell.RegRead("HKEY_CLASSES_ROOT\" ^& args(0) ^& "\") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = shell.RegRead("HKEY_CLASSES_ROOT\" ^& apptype ^& "\shell\open\command\") >> "%fscAppPath%\fscApplicationInfo.vbs"
echo End If >> "%fscAppPath%\fscApplicationInfo.vbs"
echo End If >> "%fscAppPath%\fscApplicationInfo.vbs"
echo If InStr(application, """") ^<^> 0 Then >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = Split(application, """")(1) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo Else >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = Split(application, " ")(0) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo End If >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = Replace(application, "%%ProgramFiles%%", shell.ExpandEnvironmentStrings("%%ProgramFiles%%")) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = Replace(application, "%%ProgramFiles(x86)%%", shell.ExpandEnvironmentStrings("%%ProgramFiles(x86)%%")) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo application = Replace(application, "%%SystemRoot%%", shell.ExpandEnvironmentStrings("%%SystemRoot%%")) >> "%fscAppPath%\fscApplicationInfo.vbs"
echo WScript.Echo application >> "%fscAppPath%\fscApplicationInfo.vbs"
::Create fscRegInfo.vbs 
echo ' Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscRegInfo.vbs"
echo '  >> "%fscAppPath%\fscRegInfo.vbs"
echo ' All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscRegInfo.vbs"
echo ' trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscRegInfo.vbs"
echo '  >> "%fscAppPath%\fscRegInfo.vbs"
echo ' The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscRegInfo.vbs"
echo ' notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscRegInfo.vbs"
echo ' at the position in the function of the computer program which the author has >> "%fscAppPath%\fscRegInfo.vbs"
echo ' deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscRegInfo.vbs"
echo ' customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscRegInfo.vbs"
echo ' copyright notice. >> "%fscAppPath%\fscRegInfo.vbs"
echo Set args = WScript.Arguments >> "%fscAppPath%\fscRegInfo.vbs"
echo Set reg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv") >> "%fscAppPath%\fscRegInfo.vbs"
echo Set regex=New RegExp >> "%fscAppPath%\fscRegInfo.vbs"
echo Set shell=CreateObject("Wscript.Shell") >> "%fscAppPath%\fscRegInfo.vbs"
echo If args.Count ^> 2 Then regex.Pattern=args(2) Else regex.Pattern=".*" End If >> "%fscAppPath%\fscRegInfo.vbs"
echo If args(0) = "HKEY_LOCAL_MACHINE" Then >> "%fscAppPath%\fscRegInfo.vbs"
echo listKey ^&H80000002,args(1) >> "%fscAppPath%\fscRegInfo.vbs"
echo Else If args(0) = "HKEY_CURRENT_USER" Then >> "%fscAppPath%\fscRegInfo.vbs"
echo listKey ^&H80000001,args(1) >> "%fscAppPath%\fscRegInfo.vbs"
echo Else >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Quit >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo Sub listKey(hive,key) >> "%fscAppPath%\fscRegInfo.vbs"
echo Dim name >> "%fscAppPath%\fscRegInfo.vbs"
echo Dim pad >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo args(0)^&"\"^&key >> "%fscAppPath%\fscRegInfo.vbs"
echo reg.EnumValues hive,key,vNames,vTypes >> "%fscAppPath%\fscRegInfo.vbs"
echo If Not IsNull(vNames) Then >> "%fscAppPath%\fscRegInfo.vbs"
echo For i=0 To UBound(vNames) >> "%fscAppPath%\fscRegInfo.vbs"
echo If regex.Test(vNames(i)) Then >> "%fscAppPath%\fscRegInfo.vbs"
echo If Len(vNames(i))=0 Then >> "%fscAppPath%\fscRegInfo.vbs"
echo name = "(Default)" >> "%fscAppPath%\fscRegInfo.vbs"
echo Else >> "%fscAppPath%\fscRegInfo.vbs"
echo name=vNames(i) >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo If Len(name)^<16 Then >> "%fscAppPath%\fscRegInfo.vbs"
echo pad=Space(16-Len(name)) >> "%fscAppPath%\fscRegInfo.vbs"
echo Else >> "%fscAppPath%\fscRegInfo.vbs"
echo pad="" >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo Select Case vTypes(i) >> "%fscAppPath%\fscRegInfo.vbs"
echo Case 1 >> "%fscAppPath%\fscRegInfo.vbs"
echo reg.GetStringValue hive,key,vNames(i),value >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo "  "^&name^&pad^&"  REG_SZ     "^&value >> "%fscAppPath%\fscRegInfo.vbs"
echo Case 4 >> "%fscAppPath%\fscRegInfo.vbs"
echo reg.GetDWORDValue hive,key,vNames(i),value >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo "  "^&name^&pad^&"  REG_DWORD  "^&value >> "%fscAppPath%\fscRegInfo.vbs"
echo Case 11 >> "%fscAppPath%\fscRegInfo.vbs"
echo reg.GetQWORDValue hive,key,vNames(i),value >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo "  "^&name^&pad^&"  REG_QWORD  "^&value >> "%fscAppPath%\fscRegInfo.vbs"
echo Case else >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo "  "^&name^&pad^&"  "^&vTypes(i) >> "%fscAppPath%\fscRegInfo.vbs"
echo End Select >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo Next >> "%fscAppPath%\fscRegInfo.vbs"
echo Else >> "%fscAppPath%\fscRegInfo.vbs"
echo On Error Resume Next >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo "  (Default)         REG_SZ     "^&shell.RegRead(args(0)^&"\"^&key^&"\") >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo WScript.Echo >> "%fscAppPath%\fscRegInfo.vbs"
echo reg.EnumKey hive,key,vKeys >> "%fscAppPath%\fscRegInfo.vbs"
echo If Not IsNull(vKeys) Then >> "%fscAppPath%\fscRegInfo.vbs"
echo For Each subkey In vKeys >> "%fscAppPath%\fscRegInfo.vbs"
echo listKey hive,key^&"\"^&subkey >> "%fscAppPath%\fscRegInfo.vbs"
echo Next >> "%fscAppPath%\fscRegInfo.vbs"
echo End If >> "%fscAppPath%\fscRegInfo.vbs"
echo End Sub >> "%fscAppPath%\fscRegInfo.vbs"
::Create fscRegValue.vbs 
echo ' Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscRegValue.vbs"
echo '  >> "%fscAppPath%\fscRegValue.vbs"
echo ' All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscRegValue.vbs"
echo ' trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscRegValue.vbs"
echo '  >> "%fscAppPath%\fscRegValue.vbs"
echo ' The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscRegValue.vbs"
echo ' notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscRegValue.vbs"
echo ' at the position in the function of the computer program which the author has >> "%fscAppPath%\fscRegValue.vbs"
echo ' deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscRegValue.vbs"
echo ' customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscRegValue.vbs"
echo ' copyright notice. >> "%fscAppPath%\fscRegValue.vbs"
echo Set args = WScript.Arguments >> "%fscAppPath%\fscRegValue.vbs"
echo Set shell = CreateObject("Wscript.Shell") >> "%fscAppPath%\fscRegValue.vbs"
echo Set regex = new RegExp >> "%fscAppPath%\fscRegValue.vbs"
echo If args.Count ^> 1 Then >> "%fscAppPath%\fscRegValue.vbs"
echo regex.Pattern = args(1) >> "%fscAppPath%\fscRegValue.vbs"
echo If args.Count ^> 2 Then >> "%fscAppPath%\fscRegValue.vbs"
echo WScript.Echo regex.Execute(shell.RegRead(args(0))(args(2))).Item(0).Value >> "%fscAppPath%\fscRegValue.vbs"
echo Else >> "%fscAppPath%\fscRegValue.vbs"
echo WScript.Echo regex.Execute(shell.RegRead(args(0))).Item(0).Value >> "%fscAppPath%\fscRegValue.vbs"
echo End If >> "%fscAppPath%\fscRegValue.vbs"
echo Else >> "%fscAppPath%\fscRegValue.vbs"
echo WScript.Echo shell.RegRead(args(0)) >> "%fscAppPath%\fscRegValue.vbs"
echo End If >> "%fscAppPath%\fscRegValue.vbs"
::Create fscVersionInfo.vbs 
echo ' Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscVersionInfo.vbs"
echo '  >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscVersionInfo.vbs"
echo '  >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' at the position in the function of the computer program which the author has >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscVersionInfo.vbs"
echo ' copyright notice. >> "%fscAppPath%\fscVersionInfo.vbs"
echo Set args=WScript.Arguments >> "%fscAppPath%\fscVersionInfo.vbs"
echo Set fso=CreateObject("Scripting.FileSystemObject") >> "%fscAppPath%\fscVersionInfo.vbs"
echo WScript.Echo fso.GetFileVersion(args(0)) ^& " (" ^& fso.GetFile(args(0)).Size ^& ")" >> "%fscAppPath%\fscVersionInfo.vbs"
::Create fscZip.vbs 
echo ' Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscZip.vbs"
echo '  >> "%fscAppPath%\fscZip.vbs"
echo ' All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscZip.vbs"
echo ' trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscZip.vbs"
echo '  >> "%fscAppPath%\fscZip.vbs"
echo ' The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscZip.vbs"
echo ' notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscZip.vbs"
echo ' at the position in the function of the computer program which the author has >> "%fscAppPath%\fscZip.vbs"
echo ' deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscZip.vbs"
echo ' customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscZip.vbs"
echo ' copyright notice. >> "%fscAppPath%\fscZip.vbs"
echo Set args = WScript.Arguments >> "%fscAppPath%\fscZip.vbs"
echo Set fso = CreateObject("Scripting.FileSystemObject") >> "%fscAppPath%\fscZip.vbs"
echo Set oshell = CreateObject("Shell.Application") >> "%fscAppPath%\fscZip.vbs"
echo Set sshell = CreateObject("Wscript.Shell") >> "%fscAppPath%\fscZip.vbs"
echo CreateObject("Scripting.FileSystemObject").CreateTextFile(args(1), True).Write "PK" ^& Chr(5) ^& Chr(6) ^& String(18, vbNullChar) >> "%fscAppPath%\fscZip.vbs"
echo oshell.NameSpace(args(1)).CopyHere(oshell.NameSpace(args(0)).Items) >> "%fscAppPath%\fscZip.vbs"
echo If sshell.AppActivate("Compressing...") = FALSE Then >> "%fscAppPath%\fscZip.vbs"
echo WScript.Sleep 2000 >> "%fscAppPath%\fscZip.vbs"
echo End If >> "%fscAppPath%\fscZip.vbs"
echo Do While sshell.AppActivate("Compressing...") = TRUE >> "%fscAppPath%\fscZip.vbs"
echo WScript.Sleep 500 >> "%fscAppPath%\fscZip.vbs"
echo Loop >> "%fscAppPath%\fscZip.vbs"
echo If fso.GetFile(args(1)).Size ^> 4096 Then >> "%fscAppPath%\fscZip.vbs"
echo WScript.Echo "OK" >> "%fscAppPath%\fscZip.vbs"
echo Else >> "%fscAppPath%\fscZip.vbs"
echo WScript.Echo "FAIL" >> "%fscAppPath%\fscZip.vbs"
echo End If >> "%fscAppPath%\fscZip.vbs"
goto :EOF 
:InitPowershell 
::Create fscZip.ps1 
echo # Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscZip.ps1"
echo #  >> "%fscAppPath%\fscZip.ps1"
echo # All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscZip.ps1"
echo # trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscZip.ps1"
echo #  >> "%fscAppPath%\fscZip.ps1"
echo # The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscZip.ps1"
echo # notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscZip.ps1"
echo # at the position in the function of the computer program which the author has >> "%fscAppPath%\fscZip.ps1"
echo # deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscZip.ps1"
echo # customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscZip.ps1"
echo # copyright notice. >> "%fscAppPath%\fscZip.ps1"
echo try { >> "%fscAppPath%\fscZip.ps1"
echo [System.Reflection.Assembly]::Load('WindowsBase,Version=4.0.0.0,Culture=neutral,PublicKeyToken=31bf3856ad364e35') >> "%fscAppPath%\fscZip.ps1"
echo } catch { >> "%fscAppPath%\fscZip.ps1"
echo [System.Reflection.Assembly]::Load('WindowsBase,Version=3.0.0.0,Culture=neutral,PublicKeyToken=31bf3856ad364e35') >> "%fscAppPath%\fscZip.ps1"
echo } >> "%fscAppPath%\fscZip.ps1"
echo $zipPath=$args[1]; >> "%fscAppPath%\fscZip.ps1"
echo $dirPath=$args[0]; >> "%fscAppPath%\fscZip.ps1"
echo $zip=[System.IO.Packaging.ZipPackage]::Open($zipPath, [System.IO.FileMode]::Create, [System.IO.FileAccess]::ReadWrite) >> "%fscAppPath%\fscZip.ps1"
echo $files=[System.IO.Directory]::GetFiles($dirPath, '*', [System.IO.SearchOption]'AllDirectories') >> "%fscAppPath%\fscZip.ps1"
echo ForEach($filepath In $files) { >> "%fscAppPath%\fscZip.ps1"
echo $part=$zip.CreatePart((New-Object System.Uri([System.Uri]::EscapeUriString($filepath.SubString($dirPath.Length).Replace('\', '/')), [System.UriKind]::Relative)), 'text/plain', [System.IO.Packaging.CompressionOption]::Maximum) >> "%fscAppPath%\fscZip.ps1"
echo $file=New-Object System.IO.BinaryReader(New-Object System.IO.FileStream($filepath,[System.IO.FileMode]::Open, [System.IO.FileAccess]::Read, [System.IO.FileShare]::ReadWrite)) >> "%fscAppPath%\fscZip.ps1"
echo If($part -ne $null -and $file -ne $null) { >> "%fscAppPath%\fscZip.ps1"
echo $out = $part.GetStream() >> "%fscAppPath%\fscZip.ps1"
echo $out.Write($file.ReadBytes($file.BaseStream.Length), 0, $file.BaseStream.Length) >> "%fscAppPath%\fscZip.ps1"
echo $out.Close() >> "%fscAppPath%\fscZip.ps1"
echo $file.Close() >> "%fscAppPath%\fscZip.ps1"
echo } >> "%fscAppPath%\fscZip.ps1"
echo } >> "%fscAppPath%\fscZip.ps1"
echo $zip.Close() >> "%fscAppPath%\fscZip.ps1"
::Create fscRegInfo.ps1 
echo # Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscRegInfo.ps1"
echo #  >> "%fscAppPath%\fscRegInfo.ps1"
echo # All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscRegInfo.ps1"
echo # trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscRegInfo.ps1"
echo #  >> "%fscAppPath%\fscRegInfo.ps1"
echo # The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscRegInfo.ps1"
echo # notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscRegInfo.ps1"
echo # at the position in the function of the computer program which the author has >> "%fscAppPath%\fscRegInfo.ps1"
echo # deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscRegInfo.ps1"
echo # customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscRegInfo.ps1"
echo # copyright notice. >> "%fscAppPath%\fscRegInfo.ps1"
echo function ListKey($hive, $path, $pattern) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('{0}\{1}', $hive.Name, $path)); >> "%fscAppPath%\fscRegInfo.ps1"
echo $key = $hive.OpenSubKey($path); >> "%fscAppPath%\fscRegInfo.ps1"
echo if($key.ValueCount -gt 0) { >> "%fscAppPath%\fscRegInfo.ps1"
echo [Collections.Generic.List[String]]$names = $key.GetValueNames(); >> "%fscAppPath%\fscRegInfo.ps1"
echo $names.Sort(); >> "%fscAppPath%\fscRegInfo.ps1"
echo foreach($name in $names) { >> "%fscAppPath%\fscRegInfo.ps1"
echo if($name -match $pattern) { >> "%fscAppPath%\fscRegInfo.ps1"
echo $value = $key.GetValue($name); >> "%fscAppPath%\fscRegInfo.ps1"
echo if($value -ne $null) { >> "%fscAppPath%\fscRegInfo.ps1"
echo if($value -is [String]) { >> "%fscAppPath%\fscRegInfo.ps1"
echo if([String]::IsNullOrWhiteSpace($name)) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_SZ        {1}', '(Default)', $value)); >> "%fscAppPath%\fscRegInfo.ps1"
echo } else { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_SZ        {1}', $name, $value)); >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($value -is [Int32]) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_DWORD     {1}', $name, $value)); >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($value -is [Int64]) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_QWORD     {1}', $name, $value)); >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($value -is [String[]]) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_MULTI_SZ  {1}', $name, $value[0])); >> "%fscAppPath%\fscRegInfo.ps1"
echo for($i = 1; $i -lt $value.Length; $i++) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('{0,-32}                {1}', ' ', $value[$i])); >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($value -is [Byte[]]) { >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ([String]::Format('  {0,-32}  REG_BINARY    {1}', $name, [BitConverter]::ToString($value))); >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo Write-Host ''; >> "%fscAppPath%\fscRegInfo.ps1"
echo if($key.SubKeyCount -gt 0) { >> "%fscAppPath%\fscRegInfo.ps1"
echo [Collections.Generic.List[String]]$names = $key.GetSubKeyNames(); >> "%fscAppPath%\fscRegInfo.ps1"
echo $names.Sort(); >> "%fscAppPath%\fscRegInfo.ps1"
echo foreach($name in $names) { >> "%fscAppPath%\fscRegInfo.ps1"
echo ListKey $hive ([String]::Format('{0}\{1}', $path, $name)) $pattern; >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo function Main($params) { >> "%fscAppPath%\fscRegInfo.ps1"
echo if($params.Length -ge 2) { >> "%fscAppPath%\fscRegInfo.ps1"
echo $pattern = '.*'; >> "%fscAppPath%\fscRegInfo.ps1"
echo if($params.Length -gt 2) { >> "%fscAppPath%\fscRegInfo.ps1"
echo $pattern = $params[2]; >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo if($params[0] -eq 'HKEY_LOCAL_MACHINE') { >> "%fscAppPath%\fscRegInfo.ps1"
echo ListKey ([Microsoft.Win32.Registry]::LocalMachine) $params[1] $pattern; >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($params[0] -eq 'HKEY_CURRENT_USER') { >> "%fscAppPath%\fscRegInfo.ps1"
echo ListKey ([Microsoft.Win32.Registry]::CurrentUser) $params[1] $pattern; >> "%fscAppPath%\fscRegInfo.ps1"
echo } elseif($params[0] -eq 'HKEY_CLASSES_ROOT') { >> "%fscAppPath%\fscRegInfo.ps1"
echo ListKey ([Microsoft.Win32.Registry]::ClassesRoot) $params[1] $pattern; >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo } >> "%fscAppPath%\fscRegInfo.ps1"
echo Main $args; >> "%fscAppPath%\fscRegInfo.ps1"
::Create fscManifest.ps1 
echo # Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscManifest.ps1"
echo #  >> "%fscAppPath%\fscManifest.ps1"
echo # All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscManifest.ps1"
echo # trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscManifest.ps1"
echo #  >> "%fscAppPath%\fscManifest.ps1"
echo # The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscManifest.ps1"
echo # notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscManifest.ps1"
echo # at the position in the function of the computer program which the author has >> "%fscAppPath%\fscManifest.ps1"
echo # deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscManifest.ps1"
echo # customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscManifest.ps1"
echo # copyright notice. >> "%fscAppPath%\fscManifest.ps1"
echo $manifest=New-Object System.IO.MemoryStream; >> "%fscAppPath%\fscManifest.ps1"
echo $writer=New-Object System.IO.StreamWriter($manifest); >> "%fscAppPath%\fscManifest.ps1"
echo $sha=New-Object Security.Cryptography.SHA256Managed; >> "%fscAppPath%\fscManifest.ps1"
echo $dirPath=$args[0]; >> "%fscAppPath%\fscManifest.ps1"
echo $files=[System.IO.Directory]::GetFiles($dirPath, '*', [System.IO.SearchOption]::AllDirectories) >> "%fscAppPath%\fscManifest.ps1"
echo $writer.WriteLine('#ManifestVersion 3'); >> "%fscAppPath%\fscManifest.ps1"
echo $writer.WriteLine('#ManifestDate {0}', [System.DateTime]::Now); >> "%fscAppPath%\fscManifest.ps1"
echo ForEach ($filepath In $files) { >> "%fscAppPath%\fscManifest.ps1"
echo $writer.WriteLine('{0} *{1}', [BitConverter]::ToString($sha.ComputeHash([System.IO.File]::ReadAllBytes($filepath))).Replace('-',''), [System.Uri]::EscapeUriString($filepath.SubString($dirPath.Length + 1).Replace('\','/'))); >> "%fscAppPath%\fscManifest.ps1"
echo } >> "%fscAppPath%\fscManifest.ps1"
echo $writer.Flush(); >> "%fscAppPath%\fscManifest.ps1"
echo [System.IO.File]::WriteAllBytes($dirPath + '\manifest.sha256',$manifest.ToArray()); >> "%fscAppPath%\fscManifest.ps1"
::Create fscApplicationInfo.ps1 
echo # Copyright  Fabasoft Austria GmbH, Linz, Austria, 2012-2018 > "%fscAppPath%\fscApplicationInfo.ps1"
echo #  >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # All rights reserved. All hardware and software names used are registered >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # trade names and/or registered trademarks of the respective manufacturers. >> "%fscAppPath%\fscApplicationInfo.ps1"
echo #  >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # The user of this computer program acknowledges that the above copyright >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # notice, which constitutes the Universal Copyright Convention, will be attached >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # at the position in the function of the computer program which the author has >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # deemed to sufficiently express the reservation of copyright. It is prohibited for >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # customers, users and/or third parties to remove, modify or move this >> "%fscAppPath%\fscApplicationInfo.ps1"
echo # copyright notice. >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $extension = $args[0]; >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = $null; >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $applist = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\{0}\OpenWithList', $extension), 'MRUList', $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($applist -ne $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $apptype = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\{0}\OpenWithList', $extension), $applist[0], $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($apptype -ne $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CLASSES_ROOT\Applications\{0}\shell\open\command', $apptype), '', $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($application -eq $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CLASSES_ROOT\{0}\shell\open\command', $extension), '', $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($application -eq $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $apptype = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CLASSES_ROOT\{0}', $extension), '', $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($apptype -ne $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = [Microsoft.Win32.Registry]::GetValue([String]::Format('HKEY_CLASSES_ROOT\{0}\shell\open\command', $apptype), '', $null); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($application -ne $null) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if($application.Trim().StartsWith('^"')) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = $application.Split('^"')[1]; >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } else { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = $application.Split(' ')[0]; >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo $application = $application.Replace('%%ProgramFiles%%', $env:ProgramFiles).Replace('%%ProgramFiles(x86)%%', ${env:ProgramFiles(x86)}).Replace('%%SystemRoot%%', $env:SystemRoot); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo if([System.IO.File]::Exists($application)) { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo Write-Host ([String]::Format('{0}: {1} ({2}) [{3}]', $extension, $application, [System.Diagnostics.FileVersionInfo]::GetVersionInfo($application).FileVersion, [BitConverter]::ToString((new-object Security.Cryptography.SHA256Managed).ComputeHash([System.IO.File]::ReadAllBytes($application))).Replace('-',''))); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } else { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo Write-Host ([String]::Format('{0}: {1}', $extension, $application)); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } else { >> "%fscAppPath%\fscApplicationInfo.ps1"
echo Write-Host ([String]::Format('{0}:', $extension)); >> "%fscAppPath%\fscApplicationInfo.ps1"
echo } >> "%fscAppPath%\fscApplicationInfo.ps1"
goto :EOF 
